/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.scripting.LogLevel;
import com.aptana.scripting.ScriptLogListener;
import java.util.ArrayList;
import java.util.List;

public class ScriptLogger {
    private static ScriptLogger INSTANCE;
    private List<ScriptLogListener> _logListeners;
    private LogLevel _logLevel = LogLevel.WARNING;

    public static void logError(String message) {
        ScriptLogger.getInstance().fireLogErrorEvent(message);
    }

    public static void logInfo(String message) {
        ScriptLogger.getInstance().fireLogInfoEvent(message);
    }

    public static void logWarning(String message) {
        ScriptLogger.getInstance().fireLogWarningEvent(message);
    }

    public static void print(String message) {
        ScriptLogger.getInstance().firePrintEvent(message);
    }

    public static void printError(String message) {
        ScriptLogger.getInstance().firePrintErrorEvent(message);
    }

    public static void trace(String message) {
        ScriptLogger.getInstance().fireTraceEvent(message);
    }

    public static ScriptLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScriptLogger();
        }
        return INSTANCE;
    }

    private ScriptLogger() {
    }

    public void addLogListener(ScriptLogListener listener) {
        if (listener != null) {
            if (this._logListeners == null) {
                this._logListeners = new ArrayList<ScriptLogListener>();
            }
            this._logListeners.add(listener);
        }
    }

    public void fireLogErrorEvent(String error) {
        if (this._logListeners != null && this._logLevel.getIndex() <= LogLevel.ERROR.getIndex()) {
            for (ScriptLogListener listener : this._logListeners) {
                listener.logError(error);
            }
        }
    }

    public void fireLogInfoEvent(String info) {
        if (this._logListeners != null && this._logLevel.getIndex() <= LogLevel.INFO.getIndex()) {
            for (ScriptLogListener listener : this._logListeners) {
                listener.logInfo(info);
            }
        }
    }

    public void fireLogWarningEvent(String warning) {
        if (this._logListeners != null && this._logLevel.getIndex() <= LogLevel.WARNING.getIndex()) {
            for (ScriptLogListener listener : this._logListeners) {
                listener.logWarning(warning);
            }
        }
    }

    public void firePrintEvent(String message) {
        if (this._logListeners != null) {
            for (ScriptLogListener listener : this._logListeners) {
                listener.print(message);
            }
        }
    }

    public void firePrintErrorEvent(String message) {
        if (this._logListeners != null) {
            for (ScriptLogListener listener : this._logListeners) {
                listener.printError(message);
            }
        }
    }

    public void fireTraceEvent(String message) {
        if (this._logListeners != null && this._logLevel.getIndex() <= LogLevel.TRACE.getIndex()) {
            for (ScriptLogListener listener : this._logListeners) {
                listener.trace(message);
            }
        }
    }

    public LogLevel getLogLevel() {
        return this._logLevel;
    }

    public void removeLogListener(ScriptLogListener listener) {
        if (this._logListeners != null) {
            this._logListeners.remove(listener);
        }
    }

    public void setLogLevel(LogLevel level) {
        this._logLevel = level;
    }

    public void setLogLevel(String level) {
        this._logLevel = LogLevel.get(level);
    }
}

